/*
  wasapi.hpp (2011-10-15)
  author: Fatbag

  ruby-specific header to provide mingw-friendly wasapi interfaces
*/

#include <windows.h>
#undef NULL
#define NULL 0

#include <initguid.h>
#include <mmreg.h>

DEFINE_GUID(CLSID_MMDeviceEnumerator, 0xbcde0395, 0xe52f, 0x467c, 0x8e, 0x3d, 0xc4, 0x57, 0x92, 0x91, 0x69, 0x2e);
DEFINE_GUID(IID_IMMDeviceEnumerator, 0xa95664d2, 0x9614, 0x4f35, 0xa7, 0x46, 0xde, 0x8d, 0xb6, 0x36, 0x17, 0xe6);
DEFINE_GUID(IID_IAudioClient, 0x1cb9ad4c, 0xdbfa, 0x4c32, 0xb1, 0x78, 0xc2, 0xf5, 0x68, 0xa7, 0x03, 0xb2);
DEFINE_GUID(IID_IAudioRenderClient, 0xf294acfc, 0x3146, 0x4483, 0xa7, 0xbf, 0xad, 0xdc, 0xa7, 0xc2, 0x60, 0xe2);

DECLARE_INTERFACE(IMMDeviceCollection);
DECLARE_INTERFACE(IMMNotificationClient);
DECLARE_INTERFACE(IPropertyStore);

/*
** IMMDevice
*/

DECLARE_INTERFACE_(IMMDevice, IUnknown)
{
    STDMETHOD(Activate) (REFIID iid, DWORD dwClsCtx, PROPVARIANT *pActivationParams, void **ppInterface);
    STDMETHOD(OpenPropertyStore) (DWORD stgmAccess, IPropertyStore **ppProperties);
    STDMETHOD(GetId) (LPWSTR *ppstrId);
    STDMETHOD(GetState) (DWORD *pdwState);
};

/*
** IMMDeviceEnumerator
*/

enum EDataFlow
{
    eRender,
    eCapture,
    eAll
};

enum ERole
{
    eConsole,
    eMultimedia,
    eCommunications
};

DECLARE_INTERFACE_(IMMDeviceEnumerator, IUnknown)
{
    STDMETHOD(EnumAudioEndpoints) (EDataFlow dataFlow, DWORD dwStateMask, IMMDeviceCollection **ppDevices);
    STDMETHOD(GetDefaultAudioEndpoint) (EDataFlow dataFlow, ERole role, IMMDevice **ppEndpoint);
    STDMETHOD(GetDevice) (LPCWSTR pwstrId, IMMDevice **ppDevice);
    STDMETHOD(RegisterEndpointNotificationCallback) (IMMNotificationClient *pClient);
    STDMETHOD(UnregisterEndpointNotificationCallback) (IMMNotificationClient *pClient);
};

/*
** IAudioClient
*/

enum AUDCLNT_SHAREMODE
{
    AUDCLNT_SHAREMODE_SHARED,
    AUDCLNT_SHAREMODE_EXCLUSIVE
};

enum AUDCLNT_STREAMFLAGS
{
    AUDCLNT_STREAMFLAGS_CROSSPROCESS             = 0x00010000,
    AUDCLNT_STREAMFLAGS_LOOPBACK                 = 0x00020000,
    AUDCLNT_STREAMFLAGS_EVENTCALLBACK            = 0x00040000,
    AUDCLNT_STREAMFLAGS_NOPERSIST                = 0x00080000,
    AUDCLNT_STREAMFLAGS_RATEADJUST               = 0x00100000,
    AUDCLNT_SESSIONFLAGS_EXPIREWHENUNOWNED       = 0x10000000,
    AUDCLNT_SESSIONFLAGS_DISPLAY_HIDE            = 0x20000000,
    AUDCLNT_SESSIONFLAGS_DISPLAY_HIDEWHENEXPIRED = 0x40000000
};

DECLARE_INTERFACE_(IAudioClient, IUnknown)
{
    STDMETHOD(Initialize) (AUDCLNT_SHAREMODE ShareMode, DWORD StreamFlags, LONGLONG hnsBufferDuration,
        LONGLONG hnsPeriodicity, const WAVEFORMATEX *pFormat, LPCGUID AudioSessionGuid);
    STDMETHOD(GetBufferSize) (UINT32 *pNumBufferFrames);
    STDMETHOD(GetStreamLatency) (LONGLONG *phnsLatency);
    STDMETHOD(GetCurrentPadding) (UINT32 *pNumPaddingFrames);
    STDMETHOD(IsFormatSupported) (AUDCLNT_SHAREMODE ShareMode, const WAVEFORMATEX *pFormat, WAVEFORMATEX **ppClosestMatch);
    STDMETHOD(GetMixFormat) (WAVEFORMATEX **ppDeviceFormat);
    STDMETHOD(GetDevicePeriod) (LONGLONG *phnsDefaultDevicePeriod, LONGLONG *phnsMinimumDevicePeriod);
    STDMETHOD(Start) (void);
    STDMETHOD(Stop) (void);
    STDMETHOD(Reset) (void);
    STDMETHOD(SetEventHandle) (HANDLE eventHandle);
    STDMETHOD(GetService) (REFIID riid, void **ppv);
};

/*
** IAudioRenderClient
*/

enum AUDCLNT_BUFFERFLAGS
{
    AUDCLNT_BUFFERFLAGS_DATA_DISCONTINUITY = 0x1,
    AUDCLNT_BUFFERFLAGS_SILENT             = 0x2,
    AUDCLNT_BUFFERFLAGS_TIMESTAMP_ERROR    = 0x4
};

DECLARE_INTERFACE_(IAudioRenderClient, IUnknown)
{
    STDMETHOD(GetBuffer) (UINT32 NumFramesRequested, BYTE **ppData);
    STDMETHOD(ReleaseBuffer) (UINT32 NumFramesWritten, DWORD dwFlags);
};